#version 130
#extension GL_EXT_gpu_shader4 : enable
//Cubescape 1_1Mod01.fsh  by  morgan3d 
//https://www.shadertoy.com/view/Xsl3DB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define iMouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by inigo quilez - iq/2013 
//   original at https://www.shadertoy.com/view/Msl3Rr
// Modified by Morgan McGuire 2013 (http://graphicscodex.com)
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float hash( float n ) {
    return fract(sin(n)*43758.5453123);
}

float noise( in vec3 x ) {
    vec3 p = floor(x);
    vec3 f = fract(x);

    f = f*f*(3.0-2.0*f);

    float n = p.x + p.y*57.0 + 113.0*p.z;

    float res = mix(mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
                        mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
                    mix(mix( hash(n+113.0), hash(n+114.0),f.x),
                        mix( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
    return res;
}

mat3 m3 = mat3( 0.00,  0.80,  0.60,
               -0.80,  0.36, -0.48,
               -0.60, -0.48,  0.64 );

float fbm( vec3 p ) {
    float f = 0.0;

    f += 0.5000*noise( p ); p = m3*p*2.02;
    f += 0.2500*noise( p ); p = m3*p*2.03;
    f += 0.1250*noise( p ); p = m3*p*2.01;
    f += 0.0625*noise( p );

    return f/0.9375;
}



float dbox( vec3 p, vec3 b, float r ) {
  return length(max(abs(p)-b,0.0))-r;
}

float freqs[4];

float height(in vec3 pos) {
	vec2 fpos = fract( pos.xz ); 
	vec2 ipos = floor( pos.xz );
		
    float f = 0.0;	
	float id = hash( ipos.x + ipos.y*57.0 );
	f  = freqs[0] * clamp(1.0 - abs(id-0.20)/0.30, 0.0, 1.0 );
	f += freqs[1] * clamp(1.0 - abs(id-0.40)/0.30, 0.0, 1.0 );
	f += freqs[2] * clamp(1.0 - abs(id-0.60)/0.30, 0.0, 1.0 );
	f += freqs[3] * clamp(1.0 - abs(id-0.80)/0.30, 0.0, 1.0 );
	f = pow( clamp( f*0.75, 0.0, 1.0 ), 2.0 );
    return 0.5 + 3.0*f;
}

vec3 map( in vec3 pos ) {

	vec2 fpos = fract( pos.xz ); 
	vec2 ipos = floor( pos.xz );
		
    float f = 0.0;	
	float id = hash( ipos.x + ipos.y*57.0 );
	f  = freqs[0] * clamp(1.0 - abs(id-0.20)/0.30, 0.0, 1.0 );
	f += freqs[1] * clamp(1.0 - abs(id-0.40)/0.30, 0.0, 1.0 );
	f += freqs[2] * clamp(1.0 - abs(id-0.60)/0.30, 0.0, 1.0 );
	f += freqs[3] * clamp(1.0 - abs(id-0.80)/0.30, 0.0, 1.0 );
	f = pow( clamp( f*0.75, 0.0, 1.0 ), 2.0 );
    float h = 0.5 + 3.0*f;
	float dis = dbox( vec3(fpos.x-0.5,pos.y-0.5*h,fpos.y-0.5), vec3(0.3,h*0.5,0.3), 0.15 );

    return vec3( dis,id, f );
}


const float surface = 0.01;

vec3 trace( in vec3 ro, in vec3 rd, in float startf, in float maxd )
{ 
    float s = surface*2.0;
    float t = startf;

    float sid = -1.0;
	float alt = 0.0;
    for( int i = 0; i < 256; ++i ) {
		if( s>=surface && t<=maxd ) {
			s = max(s, 0.05);
			t += 0.1 * s;
			vec3 res = map( ro + rd*t );
			s   = res.x;
			sid = res.y;
			alt = res.z;
		}
    }
    if( (t > maxd)&& (s > surface * 2.0) ) sid = -1.0;
    return vec3( t, sid, alt );
}

float softshadow( in vec3 ro, in vec3 rd, in float mint, in float maxt, in float k )
{
    float res = 1.0;
    float dt = 0.02;
    float t = mint;
	ro += rd * 0.4;
    for( int i=0; i<32; i++ )
    {
        float h = map( ro + rd*t ).x;
        res = min( res, k*h/t );
        t += max( 0.05, dt );
    }
    return clamp( res, 0.0, 1.0 );
}

vec3 calcNormal( in vec3 pos )
{
	vec3 eps = vec3(surface*0.5,0.0,0.0);
	vec3 nor;
	float f = map(pos-eps.xyy).x;
	nor.x = map(pos+eps.xyy).x - f;
	nor.y = map(pos+eps.yxy).x - f;
	nor.z = map(pos+eps.yyx).x - f;
	return normalize(nor);
}


vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 xy = -1.0 + 2.0*fragCoord.xy / iResolution.xy;
    xy.x *= iResolution.x/iResolution.y;
	
    float time = 5.0 + 0.2*iTime + 20.0*iMouse.x/iResolution.x;

	freqs[0] = texture( iChannel0, vec2( 0.01, 0.25 ) ).x;
	freqs[1] = texture( iChannel0, vec2( 0.07, 0.25 ) ).x;
	freqs[2] = texture( iChannel0, vec2( 0.15, 0.25 ) ).x;
	freqs[3] = texture( iChannel0, vec2( 0.30, 0.25 ) ).x;

    // camera	
	vec3 ro = vec3( 8.5*cos(0.2+.33*time), 5.0+2.0*cos(0.1*time), 8.5*sin(0.1+0.37*time) );
	vec3 ta = vec3( -2.5+3.0*cos(1.2+.41*time), 0.0, 2.0+3.0*sin(2.0+0.38*time) );
	float roll = 0.2*sin(0.1*time);
	
	// camera tx
	vec3 cw = normalize(ta-ro);
	vec3 cp = vec3(sin(roll), cos(roll),0.0);
	vec3 cu = normalize(cross(cw,cp));
	vec3 cv = normalize(cross(cu,cw));
	vec3 rd = normalize( xy.x*cu + xy.y*cv + 1.75*cw );
	
    // image
    vec3 col = vec3( 0.0 );
	
    vec3 res = trace( ro, rd, 0.025, 40.0 );
    float t = res.x;
    float sid = res.y;


	vec3 light1 = vec3(  0.577, 0.577, -0.577 );
    vec3 light2 = vec3( -0.707, 0.000,  0.707 );
    vec3 lpos = vec3(0.0) + 6.0*light1;
	
    if (sid>-0.5)
    {
    vec3 pos = ro + t*rd;
    vec3 nor = calcNormal( pos);
	    
	  
    // lighting
    vec3  ldif = pos - lpos;
    float llen = length( ldif );
    ldif /= llen;
	float con = dot(-light1,ldif);
	float occ = mix( clamp( pos.y/4.0, 0.0, 1.0 ), 1.0, max(0.0,nor.y) );
	float sha =  softshadow( pos, -ldif, 0.01, 5.0, 32.0 );;
		
    float bb = smoothstep( 0.5, 0.8, con );
    float lkey = clamp( dot(nor,-ldif), 0.0, 1.0 );
	vec3  lkat = vec3(1.0);
          lkat *= vec3(bb*bb*0.6+0.4*bb,bb*0.5+0.5*bb*bb,bb).zyx;
          lkat /= 1.0+0.25*llen*llen;		
		  lkat *= 25.0;
          lkat *= sha;
    float lbac = clamp( 0.1 + 0.9*dot( light2, nor ), 0.0, 1.0 );
          lbac *= smoothstep( 0.0, 0.8, con );
		  lbac /= 1.0+0.2*llen*llen;		
		  lbac *= 4.0;
	float lamb = 1.0 - 0.5*nor.y;
          lamb *= 1.0-smoothstep( 10.0, 25.0, length(pos.xz) );
		  lamb *= 0.25 + 0.75*smoothstep( 0.0, 0.8, con );
		  lamb *= 0.25;
		
    vec3 lin  = 1.0*vec3(0.20,0.05,0.02)*lamb*occ;
         lin += 1.0*vec3(1.60,0.70,0.30)*lkey*lkat*(0.5+0.5*occ);
         lin += 1.0*vec3(0.70,0.20,0.08)*lbac*occ;
         lin *= vec3(1.3,1.1,1.0);

		
    // material	
	col = 0.5 + 0.5*vec3( cos(0.0+6.2831*sid),		
                          cos(0.4+6.2831*sid),
                          cos(0.8+6.2831*sid) );
    float ff = fbm( 10.0*vec3(pos.x,4.0*res.z-pos.y,pos.z)*vec3(1.0,0.1,1.0) );	
    col *= 0.2 + 0.8*ff;
		
	col = col*lin;

    vec3 spe = vec3(1.0)*occ*lkat*pow( clamp(dot( reflect(rd,nor), -ldif  ),0.0,1.0), 4.0 );
	col += (0.5+0.5*ff)*0.5*spe*vec3(1.0,0.9,0.7);
    }

	
	col = sqrt( col );
	

    // vigneting
	vec2 q = fragCoord.xy/iResolution.xy;
    col *= 0.2 + 0.8*pow( 16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y), 0.1 );

    fragColor=vec4( col, 1.0 );
    return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.